//
//  GSAlignmentZone.h
//  GlyphsCore
//
//  Created by Georg Seifert on 18.08.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSBase.h>
#import <GlyphsCore/GSContainerProtocol.h>

NS_ASSUME_NONNULL_BEGIN

@interface GSAlignmentZone : NSObject <GSItemProtocol> {
	NSString *_name;
	CGFloat _position;
	CGFloat _size;
	NSPredicate *_filter;
	NSMutableDictionary *_options;
}

@property (nonatomic, strong, nullable) NSString *name;

@property (nonatomic) CGFloat position;

@property (nonatomic) CGFloat size;

@property (nonatomic, retain, nullable) NSPredicate *filter;

@property (nonatomic, retain, nullable) NSDictionary *options;

@property (nonatomic, strong, nullable) NSDictionary *delta;

- (instancetype)initWithElementString:(NSString *)string;

- (instancetype)initWithDict:(NSDictionary *)dict format:(GSFormatVersion)formatVersion;

- (NSString *)elementString;

- (void)postRead:(GSFormatVersion)formatVersion;

#ifndef GLYPHS_VIEWER
- (BOOL)saveToFile:(FILE *)file format:(GSFormatVersion)formatVersion error:(NSError **)error;

- (id)propertyListValueFormat:(GSFormatVersion)format;

- (id)objectInSettingsForKey:(nullable NSString *)key;

- (void)setObjectInSettings:(nullable id)value forKey:(nullable NSString *)key;
#endif

@end

NS_ASSUME_NONNULL_END
